/*****************************************************************************
 $Id: PassPhrasePanel.java,v 1.2 2002/04/08 12:09:44 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex.GUI;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import trex.*;

/**
 * This panel provides a pass phrase input dialog for TRex.
 */

public class PassPhrasePanel extends JPanel {
  /** jbuilder GUI data. */
  JPanel jButtonPanel = new JPanel();
  GridLayout gridLayout1 = new GridLayout();
  JPanel jLabelPanel = new JPanel();
  JLabel jPassLabel = new JLabel();
  JButton jSetNewButton = new JButton();
  JButton jResetButton = new JButton();
  FlowLayout flowLayout1 = new FlowLayout();
  JPanel jEditPanel = new JPanel();
  JTextField jPassPhraseEdit = new JTextField();

  /** TRex Data Object - for callback of "setPassPhrase". */
  StegData data;
  String currentPassPhrase;

  /**
   * Constructor.
   * Initializes Dialog and stores parameters.
   * @param data Data object to inform of pass phrase changes.
   * @param pp Initial pass phrase.
   */
  public PassPhrasePanel(StegData data, String pp) {
    this.data = data;
    currentPassPhrase = pp;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    setLabel();
  }

  /** Init dialog. */
  private void jbInit() throws Exception {
    this.setLayout(gridLayout1);
    jPassLabel.setText("Passphrase is");
    jSetNewButton.setText("Set new pass phrase");
    jSetNewButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jSetNewButton_actionPerformed(e);
      }
    });
    jResetButton.setText("Reset pass phrase");
    jResetButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jResetButton_actionPerformed(e);
      }
    });

    gridLayout1.setColumns(1);
    gridLayout1.setRows(5);
    jLabelPanel.setLayout(flowLayout1);
    jPassPhraseEdit.setColumns(50);
    jLabelPanel.add(jPassLabel, null);
    this.add(jLabelPanel, null);
    this.add(jEditPanel, null);
    this.add(jButtonPanel, null);

    jEditPanel.add(jPassPhraseEdit, null);

    jButtonPanel.add(jSetNewButton, null);
    jButtonPanel.add(jResetButton, null);
    jPassPhraseEdit.setText(currentPassPhrase);
  }

  /** set "current pass phrase" label accordingly. */
  private void setLabel() {
    String newLabelString;
    if (currentPassPhrase == null)
      newLabelString = "Pass phrase is unset.";
    else if (currentPassPhrase.equals(""))
      newLabelString = "Pass phrase is empty (\"\")";
    else
      newLabelString = "Pass phrase is \"" + currentPassPhrase + "\"";

    jPassLabel.setText(newLabelString);
  }

  /**
   * Reset button action performed.
   * @param e ActionEvent.
   */
  void jResetButton_actionPerformed(ActionEvent e) {
    currentPassPhrase = null;
    setLabel();
    data.setPassPhrase(currentPassPhrase);
  }

  /**
   * Set new pass phrase performed.
   * @param e ActionEvent.
   */
  void jSetNewButton_actionPerformed(ActionEvent e) {
    currentPassPhrase = jPassPhraseEdit.getText();
    setLabel();
    data.setPassPhrase(currentPassPhrase);
  }
}