/*****************************************************************************
 $Id: ImageChooserUtils.java,v 1.7 2002/04/08 12:09:44 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex.GUI.ImageChooser;

import java.io.File;

/**
 * Stupid helper class for filechooser.
 * Returns extension of a given file and knows about image suffixes.
 * <p>This class was mostly stolen from Sun's documentation:
 * <a href="http://java.sun.com/docs/books/tutorial/uiswing/components/filechooser.html">FileChooser
 * Demo</a> (whoops... does this hurt GPL?!)</p>
 * @author Bastian Friedrich <a href="mailto:bastian@bastian-friedrich.de">&lt;bastian@bastian-friedrich.de&gt;</a>
 * @version $Revision: 1.7 $
 */
public class ImageChooserUtils {

    /**
     * Image suffixes.
     */
    public final static String jpeg = "jpeg";
    /**
     * Image suffixes.
     */
    public final static String jpg = "jpg";
    /**
     * Image suffixes.
     */
    public final static String gif = "gif";
    /**
     * Image suffixes.
     */
    public final static String png = "png";

    /**
     * Get the extension of a file.
     * @return File extension.
     */
    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');

        if (i > 0 &&  i < s.length() - 1) {
            ext = s.substring(i+1).toLowerCase();
        }
        return ext;
    }
}
